function varargout = chris_step_manual_gui(A)
% res = chris_step_manual_gui()
%
% A program to manually browse step injection data and check whether the spikes were identified properly.
% Relies on a whole bunch of raw abf files, Excel file with identified spike parameters, and a "key" tab 
% in the same file. All files are explicitly referenced in the text.

% Sep 04 2014: Created.
% Sep 09 2014: Some debugging + outputs adjusted.
% Sep 11 2014: Minor edits only.


fileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Spikes data CURRENT.xlsx';
stepsFolder = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Raw Steps\';
sheetKey = 'key';
sheet3sp = 'first3sp';

%%%%% ========================================== CLARIFYING INPUT DATA ===============================
if(nargin<1)
    fprintf('No arguments, so reading a file now... ');
    [keyNum,keyText] = xlsread(fileName,sheetKey);
    temp2 = xlsread(fileName,sheet3sp);
    fprintf('Done\n');

    ids      = keyNum(:,1);
    topTrace = keyNum(:,3);             % It's actually best trace, not top trace
    abfFiles = {keyText{2:end,2}};      % That's where they seem to end up
    data     = temp2(4:end,13:end);     % All data for 3 first spikes. Period of 18 columns
    dataId   = temp2(4:end,1);          % id list from the data file
    
    A.ids = ids;
    A.topTrace = topTrace;              % Best current injection (the one that produced most spikes and is central enough)
    A.files = abfFiles;
    A.data = data;
    A.dataId = dataId;
    varargout{1} = A;                   % Pack into a structure and send back, for faster work
    %return;
else
    ids = A.ids;                        % Unpack
    topTrace = A.topTrace;
    abfFiles = A.files;    
    data = A.data;
    dataId = A.dataId;
    fprintf('Input data received and unpacked\n');
end

%%%%% ========================================== Pre-processing ===============================
S.nCell   = length(ids);
S.iCell   = 1;                          % Current cell
S.oldiCell = 0;                         % Creating a discrepancy to trigger proper abf reading
S.bestTrace = topTrace;                 % This will become our main output
S.ids = ids;                            % Mostly for output purposes
S.topTrace  = topTrace;                 % Also for output

%%%%% ========================================== CREATING GUI ===============================
hF = figure;
fpos = get(hF,'Position');
set(hF,'Position',[fpos(1)-fpos(3)/2 fpos(2) fpos(3)*2 fpos(4)]); drawnow; % Without 'drawnow' returns an error every now and then (when position is requested before being finalized)
set(hF,'WindowButtonMotionFcn',@hoverfunction,'ButtonDownFcn',@mousepressfunction,'KeyPressFcn',@keyfunction,'ResizeFcn',@resizefunction);
S.hA = axes;
hold on; % Pre-create high level graphic objects here
for(q=1:9)
    S.hPback(q) = plot(1,1,'-','Color',[7 9 8]/9);      % All traces but the top one
end
S.hPback(10) = plot(1,1,'-','Color',[9 7 7]/9);              % Top trace
S.hP = plot(1,1,'k-');
S.hPpeak = plot(1,1,'r+');
S.hPkink = plot(1,1,'m.');
S.hText = text(250,120,'Heh =)');
hold off;
S.hTitle = title('');
set(S.hA,'Xlim',[1 300]);

% Set mouse function for all created objects, as axes function won't work for them
set(S.hA,'ButtonDownFcn',@mousepressfunction);
set(S.hP,'ButtonDownFcn',@mousepressfunction);
set(S.hPpeak,'ButtonDownFcn',@mousepressfunction);
set(S.hPkink,'ButtonDownFcn',@mousepressfunction);
for(q=1:10)
    set(S.hPback(q),'ButtonDownFcn',@mousepressfunction);
end

% Initialize global variables here
S.flagUpdate = 1; % When set to 1, the main function will be called

% Initialize local variables here
flag = 1; % Main rotating flag (while==1, the program runs)

set(hF,'UserData',S); % Send the stuff there
resizefunction;

while(flag)
    try
        S = get(hF,'UserData');
    catch % Probably the figure was closed
        flag = 0; break; % Leave the cycle
    end
    
    if(S.flagUpdate) % Somebody pressed the button - time to move to the next sweep    
        if(S.oldiCell~=S.iCell)
            rawData = read_raw_data(S,stepsFolder,abfFiles);            % Read the data
            xData = (1:size(rawData,1))/10;                             % Recook x-data            
            % S.yLim = [min(rawData(:)) max(rawData(:))];
            S.iTrace = S.bestTrace(S.iCell);
            S.oldiCell = S.iCell;
            tempCounter = 1;
            for(q=1:10)
                if(q==topTrace(S.iCell))
                    set(S.hPback(10),'YData',rawData(:,q),'XData',xData);
                else
                    set(S.hPback(tempCounter),'YData',rawData(:,q),'XData',xData);
                    tempCounter = tempCounter+1;
                end
            end
        end
        iData = find(dataId==ids(S.iCell));                     % Find this cell in the data set
        if(S.iTrace==1)
            slice = zeros(1,18);                                % No real data for first trace (the one with no injection)
        else
            slice = data(iData,(S.iTrace-2)*18 + (1:18));       % Slice of data for this trace.
        end
        peakY = slice(1:3);
        peakX = slice(4:6);
        kinkY = peakY - slice(10:12);
        kinkX = peakX - slice(13:15);   % Aproximation!!!                
        
        nSpikes = sum(peakX>0);         % only 0 to 3 (we ignore all other spikes)
        if(nSpikes>=2)
            isi = peakX(2)-peakX(1);
            amp12 = (peakY(1)-kinkY(1))/(peakY(2)-kinkY(2));
        else
            isi = NaN;
            amp12 = NaN;
        end
        if(nSpikes==3)
            isi21 = (peakX(3)-peakX(2))/(peakX(2)-peakX(1));
        else
            isi21 = NaN;
        end
                
        set(S.hP,'YData',rawData(:,S.iTrace),'XData',xData);
        set(S.hTitle,'String',[num2str(ids(S.iCell)) ' - # ' num2str(S.iTrace)]);
        set(S.hPpeak,'XData',peakX,'YData',peakY); % r+
        set(S.hPkink,'XData',kinkX,'YData',kinkY); % m.   
        
        pos = get(S.hA,'YLim');
        set(S.hText,'Position',[250 pos(1)+(pos(2)-pos(1))*0.8],'String',...
            sprintf('ISI = %4.1f\nISI 2/1 = %3.1f\namp 1/2 = %3.1f',isi,isi21,amp12));
        
        S.flagUpdate = 0;
        set(hF,'UserData',S);        
    end
    drawnow;    
end

fprintf('\n');
% fprintf('.... Finished\n');
try % Enclosed in 'try' because the figure may be closed already by the user
    pause(0.1);
    close(hF);
end

end



function hoverfunction(h,event)
hF = gcf; S = get(hF,'UserData'); % Get use data
xy = get(hF,'CurrentPoint'); % Mouse location in figure coordinates
axesPos = get(S.hA,'Position');
figPos = get(hF,'Position');
S.x = (xy(1)/figPos(3)-axesPos(1))/axesPos(3); % Recalcualte into relative position within the axes
S.y = (xy(2)/figPos(4)-axesPos(2))/axesPos(4);

xLim = get(S.hA,'XLim');
yLim = get(S.hA,'YLim');
xx = (xLim(1)+(xLim(2)-xLim(1))*S.x);
yy = (yLim(1)+(yLim(2)-yLim(1))*S.y);
if((S.x>0)&&(S.x<1))
    %set(S.hP,'XData',xx,'YData',yy);
end

set(hF,'UserData',S); % Push data back
end


function mousepressfunction(h,event)
hF = gcf; S = get(hF,'UserData');
xy = get(hF,'CurrentPoint');
axesPos = get(S.hA,'Position');
figPos = get(hF,'Position');
S.xb = (xy(1)/figPos(3)-axesPos(1))/axesPos(3);
S.yb = (xy(2)/figPos(4)-axesPos(2))/axesPos(4);
S.flagNext = 1;
xl = get(S.hA,'XLim');
yl = get(S.hA,'YLim');
fprintf('Point: %d %d\n',round(xl(1)+(xl(2)-xl(1))*S.xb),round(yl(1)+(yl(2)-yl(1))*S.yb));
set(hF,'UserData',S);
end


function resizefunction(h,event)
hF = gcf; S = get(hF,'UserData');
% Do something here
set(hF,'UserData',S);
end


function keyfunction(h,event)
hF = gcf; S = get(hF,'UserData');
switch(event.Key)
    case {'a','leftarrow'}
        S.iCell = max(1,S.iCell-1);
        S.flagUpdate = 1;
    case {'d','rightarrow'}
        S.iCell = min(S.nCell,S.iCell+1);
        S.flagUpdate = 1;
    case {'w','uparrow'}
        S.iTrace = min(10,S.iTrace+1);
        S.flagUpdate = 1;
    case {'s','downarrow'}
        S.iTrace = max(1,S.iTrace-1);
        S.flagUpdate = 1;
    case 'space'
        S.bestTrace(S.iCell) = S.iTrace;
        fprintf('Best trace for cell %d set to %d\n',S.ids(S.iCell),S.iTrace);
    case 'return'
        fprintf('OUTPUT:\n');
        dispf([S.ids S.topTrace S.bestTrace],'%7d');
    otherwise
        %fprintf('%s - :)\n',event.Key);        
end
set(hF,'UserData',S);
end


function rawData = read_raw_data(S,stepsFolder,abfFiles)
% Reads an appropriate abf file
fprintf('Reading: %s\n',abfFiles{S.iCell});
temp = abfload_silent([stepsFolder abfFiles{S.iCell}]);
rawData = squeeze(temp(:,1,:));
end